package telegram;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import com.fasterxml.jackson.databind.ObjectMapper;

public class Utils {

	public static String HOST_IP = "http://129.151.46.166:9090";
	public static String ENTERPRISE = getEnterprise(getToken());
	public static String getEnterprise(String botToken)
	{
		String enterprise="";
		try {
			String urlStr = HOST_IP + "/ibase/rest/telegrambot/getEnterprise?botToken=" + botToken;
			URL url = new URL(urlStr);
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			conn.setRequestMethod("GET");
			conn.setRequestProperty("Accept", "application/json");
			if (conn.getResponseCode() != 200) {
				throw new RuntimeException("Failed :HTTP error code:" + conn.getResponseCode());
			}
			BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
			String output;

			while ((output = br.readLine()) != null) {
				enterprise += enterprise + output;
			}
		} catch (Exception e) {
			System.out.println("Error in getting enterprise "+e);
			//e.printStackTrace();
		}
		if(enterprise==null || enterprise.equals(null)|| enterprise.equals("")|| enterprise.length()==0) {
			enterprise="APPVIS";
		}
		System.out.println("Enterprise for BOT="+enterprise);
		return enterprise;
	}
	
	
	
	public UserDetails getUserDetails(String email) {
		UserDetails user = null;
		try {
			if(ENTERPRISE==null||ENTERPRISE.equals(null)||ENTERPRISE.length()==0|| ENTERPRISE.equals("")) {
				return null;
			}
			ObjectMapper mapper = new ObjectMapper();
			// String urlStr =
			// "http://65.2.88.231:9090/ibase/rest/telegrambot/getUsersDetails?userId=" +
			// userinfo;
			String urlStr = HOST_IP + "/ibase/rest/telegrambot/getUsersDetailsByEmail?emailId=" + email+"&enterprise="+ENTERPRISE;
			System.out.println("URL=" + urlStr);
			URL url = new URL(urlStr);
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			conn.setRequestMethod("GET");
			conn.setRequestProperty("Accept", "application/json");
			if (conn.getResponseCode() != 200) {
				throw new RuntimeException("Failed :HTTP error code:" + conn.getResponseCode());
			}
			BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
			String output;
			while ((output = br.readLine()) != null) {

				if (output.length() > 2) {
					System.out.println("User before mapper="+output);
					user = mapper.readValue(output, UserDetails.class);
					System.out.println("User in Util class==>" + user);
				}
			}

			
			return user;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return user;
	}

	public void sendEmail(String toEmail, String msg) {

		System.out.println("[sendEmail] :: Send Email request Executead");
		Properties emailProp = new Properties();
		InputStream input = BotLambda.class.getResourceAsStream("/resources/email.properties");
		try {
			emailProp.load(input);
		} catch (IOException e) {
			e.printStackTrace();
		}
		String to = toEmail;
		String from = emailProp.getProperty("EMAIL_FROM");
		String host = "smtp.gmail.com";
		Properties properties = System.getProperties();

		properties.put("mail.smtp.host", host);
		properties.put("mail.smtp.port", "465");
		properties.put("mail.smtp.ssl.enable", "true");
		properties.put("mail.smtp.auth", "true");

		Session session = Session.getInstance(properties, new javax.mail.Authenticator() {

			protected PasswordAuthentication getPasswordAuthentication() {
				return new PasswordAuthentication(emailProp.getProperty("EMAIL_USER_NAME"),
						emailProp.getProperty("EMAIL_PASSWORD"));
			}
		});

		// Used to debug SMTP issues
		// session.setDebug(true);
		try {
			MimeMessage message = new MimeMessage(session);
			message.setFrom(new InternetAddress(from));
			message.addRecipient(Message.RecipientType.TO, new InternetAddress(to));
			message.setSubject("Vision BOT: OTP");

			message.setContent("<p>Hello, WELCOME TO VISION BOT</p><p> Your Bot OTP: <h3>" + msg
					+ "</h3></p><p> Please Enter The OTP On Telegram Bot To Procced Further</p> <p>Thank You For Visiting.</p>",
					"text/html");
			System.out.println("[sendEmail] :: sending...");
			// Send message
			Transport.send(message);
			System.out.println("[sendEmail] :: Sent message successfully....");
		} catch (MessagingException mex) {
			mex.printStackTrace();
		}
	}

	public String generateOtp() {
		String otp = null;
		Random rnd = new Random();
		int number = rnd.nextInt(999999);
		otp = String.format("%06d", number);
		return otp;
	}

	public String addUsersChatid(String userEmail, String chatId, String userId, String userType, String botToken,String entityType) {
		try {
			String response = "";

			String urlStr = HOST_IP + "/ibase/rest/telegrambot/addUsersChatid?" 
			+ "userEmail=" + userEmail 
			+ "&chatId"+ chatId 
			+ "&userId"+ userId 
			+ "&userType"+ userType
			+ "&botToken"+ botToken
			+ "&enterprise="+ENTERPRISE
			+"&entityType="+entityType;
			URL url = new URL(urlStr);
			System.out.println();
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			conn.setRequestMethod("POST");
			conn.setRequestProperty("Accept", "application/json");
			if (conn.getResponseCode() != 200) {
				throw new RuntimeException("Failed :HTTP error code:" + conn.getResponseCode());
			}
			BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
			String output;
			while ((output = br.readLine()) != null) {
				System.out.println(output);
				if (output.length() > 2) {

					response = output;
				}
			}
			return response;
		} catch (Exception e) {
			e.printStackTrace();
			return "Error in storing User chatid";
		}
	}

	public String addUserOtp(String chatId, String otp, String userId, String userType) {
		try {
			String response = "";
			String utlParameters = "chatId=" + chatId + "&otp=" + otp + "&userID=" + userId + "&userType=" + userType;
			byte[] postData = utlParameters.getBytes(StandardCharsets.UTF_8);
			int postDataLenght = postData.length;

			String urlStr = HOST_IP + "/ibase/rest/telegrambot/addTelegramOTP?chatId=" + chatId + "&otp=" + otp
					+ "&userID=" + userId + "&userType=" + userType;

			URL url = new URL(urlStr);
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			conn.setDoOutput(true);
			conn.setInstanceFollowRedirects(false);
			conn.setRequestMethod("POST");
			conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			conn.setRequestProperty("charset", "utf-8");
			conn.setRequestProperty("Content-Length", Integer.toString(postDataLenght));
			conn.setUseCaches(false);

			if (conn.getResponseCode() != 200) {
				throw new RuntimeException("Failed :HTTP error code:" + conn.getResponseCode());
			}
			BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
			String output;
			while ((output = br.readLine()) != null) {

				if (output.length() > 2) {

					response = output;
				}
			}
			return response;
		} catch (Exception e) {
			e.printStackTrace();
			return "Error in storing User chatid";
		}
	}

	public String varifyOTP(String chatid, String otp) {
		String result = "";
		try {

			String urlStr = HOST_IP + "/ibase/rest/telegrambot/verifyOtp?chatId=" + chatid + "&otp=" + otp+"&enterprise="+ENTERPRISE;
			URL url = new URL(urlStr);
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			conn.setRequestMethod("GET");
			conn.setRequestProperty("Accept", "application/json");
			if (conn.getResponseCode() != 200) {
				throw new RuntimeException("Failed :HTTP error code:" + conn.getResponseCode());
			}
			BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
			String output;

			while ((output = br.readLine()) != null) {
				result += result + output;
			}
		} catch (Exception e) {
			e.printStackTrace();

		}
		return result;
	}
	
	public static String getToken() {
		String token="";
		try {
			Properties properties = new Properties();
			InputStream input = BotLambda.class.getResourceAsStream("/resources/api.properties");
			properties.load(input);
			token = properties.getProperty("TELEGRAM_BOT_TOKEN");
			return token;
		} catch (IOException e) {
			e.printStackTrace();
			return token;
		}
	}

	public String addChatIdOtp(String chatId, String otp) {
		try {
			String response = "";
			String utlParameters = "chatId=" + chatId + "&otp=" + otp+"&enterprise="+ENTERPRISE;
			byte[] postData = utlParameters.getBytes(StandardCharsets.UTF_8);
			int postDataLenght = postData.length;

			String urlStr = HOST_IP + "/ibase/rest/telegrambot/addUserOtp?chatId=" + chatId + "&otp=" + otp+"&enterprise="+ENTERPRISE;
			System.out.println("URL=" + urlStr);
			URL url = new URL(urlStr);
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			conn.setDoOutput(true);
			conn.setInstanceFollowRedirects(false);
			conn.setRequestMethod("POST");
			conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			conn.setRequestProperty("charset", "utf-8");
			conn.setRequestProperty("Content-Length", Integer.toString(postDataLenght));
			conn.setUseCaches(false);

			if (conn.getResponseCode() != 200) {
				throw new RuntimeException("Failed :HTTP error code:" + conn.getResponseCode());
			}
			BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
			String output;
			while ((output = br.readLine()) != null) {

				if (output.length() > 2) {

					response = output;
				}
			}
			return response;
		} catch (Exception e) {
			e.printStackTrace();
			return "Error in storing User chatid";
		}
	}

	public boolean addUserChatid(UserDetails userDetail, String chatid, String bottoken) {

		try {

			String response = null;
			String utlParameters = 
			"userEmail=" + userDetail.getEmail() 
			+"&chatId=" + chatid
			+"&userId="+ userDetail.getUserCode() 
			+"&userType=" + userDetail.getUserType() 
			+"&botToken=" + bottoken
			+"&enterprise="+ENTERPRISE
			+"&entityType="+userDetail.getEntity_type()
			+"&entityCode="+userDetail.getEntity_code()
			+"&userName="+userDetail.getUserName();

			byte[] postData = utlParameters.getBytes(StandardCharsets.UTF_8);
			int postDataLenght = postData.length;

			String urlStr=HOST_IP +"/ibase/rest/telegrambot/addUsersChatid?"
					+ "userEmail="+ userDetail.getEmail().trim()
					+ "&chatId=" + chatid
					+ "&userId=" + userDetail.getUserCode().trim()
					+ "&userType=" + userDetail.getUserType().trim()
					+ "&botToken=" + bottoken
					+"&enterprise="+ENTERPRISE
					+"&entityType="+userDetail.getEntity_type().trim()
					+"&entityCode="+userDetail.getEntity_code().trim()
					+"&userName="+userDetail.getUserName();
					//+"&userName="+userDetail.getUserCode().trim();
			System.out.println("addUserChatid url="+urlStr);

			URL url = new URL(urlStr);
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			conn.setDoOutput(true);
			conn.setInstanceFollowRedirects(false);
			conn.setRequestMethod("POST");
			conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			conn.setRequestProperty("charset", "utf-8");
			conn.setRequestProperty("Content-Length", Integer.toString(postDataLenght));
			conn.setUseCaches(false);

			if (conn.getResponseCode() != 200) {

				throw new RuntimeException("Failed :HTTP error code:" + conn.getResponseCode());
			}

			BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
			String output;
			while ((output = br.readLine()) != null) {

				if (output.length() > 2) {
					
					response = output;
				}
			}
			System.out.println("Response "+response);
			if (response.contains("Chat id Stored")) {
				return true;
			} else
				return false;
			// return response;
		} catch (Exception e) {
			e.printStackTrace();

			return false;
		}
	}

	public static void main(String[] args) {

	}

	public boolean isNumber(String otp) {
		try {
			Integer.parseInt(otp);
			return true;
		} catch (Exception e) {
			System.out.println("Not Number " + e.getMessage());
			return false;
		}
	}
	
	public boolean checkEmail(String email)
	{
		String EMAIL_PATTERN =
		        "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@"
		        + "[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
		 Pattern pattern;
	     Matcher matcher;
	     pattern = Pattern.compile(EMAIL_PATTERN);
	     matcher = pattern.matcher(email);
	     return matcher.matches();
	    
	}
}
